import numpy as np
import os

def initialize_wandb(args):
    wdb_run = None
    if len(args.record.wandb_log) > 0:
        # train.py
        import wandb

        wandb.login()

        try:
            os.makedirs(os.path.dirname(args.record.log_filename))
        except OSError as e:
            pass

        epochs = 10
        lr = 0.01
        wdb_run = wandb.init(
            # Set the project where this run will be logged
            project=args.record.wandb_log,
            # Set the experiment name, must be unique
            name=args.record.wandb_run,
            dir = os.path.dirname(args.record.log_filename),
            id=args.name_id.replace(":", ".") if "name_id" in args else "test" + str(np.random.randint(10000)),
            # Track hyperparameters and run metadata
            config=args,
        )
    return wdb_run
